require( "quest/m1_dress/convout.lua" );
combine_speech_tables();

max_beads = 12;

function dress_intro(flo)
	coroutine.yield(RESUME.ON_CLICK);
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene:DisplayFlash("flash/bobbies2_intro.swf");
	delay(1);
	scene.BOBBI:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM); -- play here to avoid animation switch being visible
	scene.BOBBI:PlayAnim("DoStandW");
	delay(1);
	--scene.BOBBI:JumpToNamedPoint("bobbie2");
	--scene.BOBBI:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);	
	run_super_conversation(flo, "quip_find_beads");
	game:Set("first_time_dress_shop", 1);
	add_quest("find_beads", false);
	add_quest("fix_beadmachine", false);
	complete_quest("check_with_bobbi");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:ModifySaySpec { mouth_in_actor = { x = -30, y = -150 } }
		actor:ModifySaySpec 
		{ 
			bubble_0 = bubble_b0_spec,
			bubble_1 = bubble_b1_spec,
			 bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP + BUBBLE.BUBBLE_AUTOVFLIP };
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		local lastScene = game:GetLastScene();
			
		if lastScene == "mg_clothing" then
			coroutine.yield(RESUME.NOW); -- wait a frame
			actor:JumpToNamedPoint("flo");
			actor:FaceNow(DIR.SE);
			wait_fade();
			
			if game:Get("mg_clothing_activity_round") < 2 then
				run_super_conversation(actor, "conv_clothes_not_done");
			else
				game:Set("clicked_on_garment_pole", 1); -- set this in case the user didn't click the garement pole
				run_super_conversation(actor, "conv_clothes_done");
				complete_quest("need_pole");
			end
			actor:SetMode(MODE.FOLLOWCLICKS);
		elseif lastScene == "mg_bead" then
			coroutine.yield(RESUME.NOW);
			actor:JumpToNamedPoint("flo");
			actor:FaceNow(DIR.SE);
			wait_fade();
			
			if game:Get("beadmachine_has_beads") < 1 then
				if game:Get("mg_bead_activity_round") == 2 then
					scene.BOBBI:PlayAnim( "Pin" );
					sfx:PlaySFX("audio/sfx/dress_reward");
					scene:Spawn(wedding_dress_beads1_spec);
					run_super_conversation(actor, "conv_bobbi_round1_done");
					complete_quest("do_beadwork", false);
					add_quest("need_beads");					
				elseif game:Get("mg_bead_activity_round") == 3 then
					sfx:PlaySFX("audio/sfx/dress_reward");
					scene:Spawn(wedding_dress_beads2_spec);
					run_super_conversation(actor, "conv_bobbi_round2_done");
					
					if quest_complete("need_lace") then
						scene.BOBBI:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);	
						scene.BOBBI:PlayAnim( "DoStand" );
						complete_quest("finish_beading", false);
						complete_wedding_dress(actor);
					else
						complete_quest("finish_beading", false);
						add_quest("need_lace");
					end
				end
			end
			actor:SetMode(MODE.FOLLOWCLICKS);
		else
			actor:JumpToNamedPoint("spendalot");
			actor:FaceNow(DIR.E);
			actor:WalkTo("flo");
			wait_walkto();
			
			actor:Face(DIR.SE);
			
			if game:Get("first_time_dress_shop") < 1 then		
				actor:StartProc(dress_intro);
			else
				actor:SetMode(MODE.FOLLOWCLICKS);
			end
		end
	end;
	
	on_arrive = function(flo, flo2)
		if game:Get("first_time_dress_panel") < 1 then
			convproc("FLO", "conv_flo_broken_machine");
		elseif not quest_complete("find_screwdriver") then
			convproc("FLO", "conv_flo_need_screwdriver");
		elseif not quest_complete("fix_beadmachine") then
			convproc("FLO", "quip_machine_broken");
		elseif game:Get("mg_bead_activity_round") < 2 then
			convproc("FLO", "conv_flo_beading_first");
		elseif game:Get("mg_bead_activity_round") < 3 and game:Get("got_beads_from_ethel") < 1 then
			convproc("FLO", "conv_flo_need_beads");
		elseif game:Get("mg_bead_activity_round") > 2 and not quest_complete("need_lace") then
			if BAG_INV:CheckInventory("curtains") == false then
				convproc("FLO", "conv_flo_need_lace");
			else
				convproc("FLO", "conv_bobbi_have_lace");
			end
		else
			convproc("FLO", "quip_other_machine");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

bobbie_anim_table =
{
	"anim/bobbie/stand",
	"anim/bobbie/talkw",
	"anim/bobbie/sweep",
};

function bobbie_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("beadmachine_panel_open") < 1 then
		run_super_conversation(flo, "conv_bobbi_closed_panel");
	elseif game:Get("beadmachine_fixed") < 1 then
		run_super_conversation(flo, "conv_bobbi_need_code");
	elseif game:Get("mg_bead_activity_round") == 2 and game:Get("got_beads_from_ethel") < 1 then
		run_super_conversation(flo, "conv_bobbi_need_beads");
	elseif game:Get("mg_bead_activity_round") == 2 and game:Get("got_beads_from_ethel") >= 1 then
		run_super_conversation(flo, "conv_bobbi_found_beads");
	elseif game:Get("mg_bead_activity_round") < 3 then
		run_super_conversation(flo, "conv_bobbi_round1");
	elseif game:Get("got_curtains") < 1 then
		run_super_conversation(flo, "conv_bobbi_need_lace");
	elseif game:Get("mg_bead_activity_round") > 2 and BAG_INV:CheckInventory("curtains") then
		run_super_conversation(flo, "conv_bobbi_have_lace");
	else
		run_super_conversation(flo, "conv_bobbi_dress_done");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_bobbie_lace(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("mg_bead_activity_round") < 3 then
		run_super_conversation(flo, "conv_bobbi_give_lace_alt");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		BAG_INV:RemoveInventory("curtains");
		run_super_conversation(flo, "conv_bobbi_give_lace");
		
		if quest_complete("finish_beading") then
			complete_quest("need_lace", false);
			complete_wedding_dress(flo);
		else
			complete_quest("need_lace");
			flo:SetMode(MODE.FOLLOWCLICKS);
		end
	end
end;

function complete_wedding_dress(flo)
	complete_quest("wedding_dress");
	game:EarnAward("avenue-flo_weddingdress");
	wait_subscene();
	
	flo:WalkTo("spendalot");
	wait_walkto();
	
	scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
	scene:SetFadeSpeed(0.05);
	scene:SetMusicVolumeSpeed(0.05);
	wait_fade();
	
	sfx:SetMusic("audio/music/music_delivery_movies.ogg", true);
	scene:DisplayFlash("flash/delivery_dress_intro.swf");
	wait_subscene();
	game:Set("just_completed_wedding_dress", 1);
	scene:ChainTo("m1_florida");
end

bobbie_spec = 
{
	name = "BOBBI";
	halo = "quest/objects/bobbiee";
	anim = bobbie_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, bobbie_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:FaceNow(DIR.W);
		
		if game:Get("first_time_dress_shop") < 1 then
			actor:JumpToNamedPoint("bobbie3");
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);			
			actor:PlayAnim("Sweep");
		else
			actor:JumpToNamedPoint("bobbie3");
		end
	end;
	
	on_arrive=  function(flo, bobbie)
		flo:StartProc(bobbie_conv);
	end;
	
	on_use_inv = function(item, flo, bobbie)
		if item == "curtains" then
			flo:StartProc(give_bobbie_lace);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
};

function use_clothing_display(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("mg_clothing_activity_round") < 1 then
		run_super_conversation(flo, "quip_clothing");
		goto_scene(flo, "mg_clothing");
	elseif game:Get("mg_clothing_activity_round") < 2 then
		goto_scene(flo, "mg_clothing");
	else
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

clothesdisplay_spec = 
{
	name = "CLOTHESDISPLAY";
	halo = "clothesdisplay";
	gfx = { image = "clothesdisplay" };

	command = function(actor)
		actor:SetDepthValue(1);
	end;

	on_arrive = function(flo, to_west)
		flo:StartProc(use_clothing_display);
	end;
}

function clickinstructions(flo)
	flo:SetMode(MODE.CUTSCENE);
	--run_super_conversation(flo, "quip_instruction_label");
	scene:ChainToSubScene("m1_dress_instructions");
	wait_subscene();
	
	if not quest_complete("find_beadmachine_code") then
		complete_quest("find_beadmachine_code", false);
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

instructions_spec = 
{
	name = "INSTRUCTIONS";
	halo = "instructions";
	gfx = { image = "instructions" };

	command = function(actor)
		actor:SetDepthValue(1);
	end;

	on_arrive = function(flo, to_west)
		flo:StartProc(clickinstructions);
	end;
}

function getscrewdriver(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_pickup_screwdriver");
	scene.SCREWDRIVER:Expire();
	addInventory(inv_desc_screwdriver);
	game:Set("got_screwdriver", 1);
	complete_quest("find_screwdriver", false);
	wait_subscene();
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

screwdriver_spec = 
{
	name = "SCREWDRIVER";
	halo = "screwdriver";
	gfx = { image = "screwdriver" };

	command = function(actor)
		actor:SetDepthMode(DEPTH_FRONTMOST);
	end;

	on_arrive = function(flo, screwdriver)
		flo:StartProc(getscrewdriver);
	end;
}

local leaveAttempt = 0;

function gotospendalot(flo)
	flo:SetMode(MODE.CUTSCENE);
	if leaveAttempt == 0 then
		if game:Get("beads_found_in_dress_shop") > 0 and game:Get("beadmachine_fixed") < 1 then
			run_super_conversation(flo, "quip_exit_screwdriver");
			flo:SetMode(MODE.FOLLOWCLICKS);
		elseif game:Get("beads_found_in_dress_shop") < max_beads then
			run_super_conversation(flo, "quip_exit_beads");
			flo:SetMode(MODE.FOLLOWCLICKS);
		else
			run_super_conversation(flo, "quip_dress_exit");
			flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			flo:WalkTo("spendalot");
			wait_walkto();
			goto_scene(flo, "m1_florida");
		end
		leaveAttempt = 1;
	else
		run_super_conversation(flo, "quip_dress_exit");
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("spendalot");
		wait_walkto();
		goto_scene(flo, "m1_florida");
	end
end

to_spendalot_spec = 
{
	name = "TO_SPENDALOT";
	halo = "door";
	cursor = "cursor_arrow_n";
	goto_fn = gotospendalot;
}

beads_Table =
{
	{ "beads01", 490 },
	{ "beads02", 1000 },
	{ "beads03", 600 },
	{ "beads04", 55	 },
	{ "beads05", 190 },
	{ "beads06", 35	 },
	{ "beads07", 115 },
	{ "beads08", 450 },
	{ "beads09", 270 },
	{ "beads10", 100 },
	{ "beads11", 150 },
	{ "beads12", 150 },
};

function wait_for_bead_fly(flo)
	local beads_found = game:Get("beads_found_in_dress_shop");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	--delay(30); -- make it snappy!
	scene.INVENTORY_FLYBACK:Expire();
	delay(2);
	
	if beads_found == max_beads then
		BAG_INV:AddInventory(inv_desc_beads);
		BAG_INV:RemoveInventory("beadcollection");
		
		BAG_INV:SetInventoryOvertextFlags("beads", kHAlignCenter + kVAlignTop);
		local beadText = tostring(beads_found) .. " / "  .. tostring(max_beads);
		BAG_INV:SetInventoryOvertext("beads", beadText);
		
		if quest_complete("fix_beadmachine") then
			add_quest("do_beadwork", false);
		end
		
		complete_quest("find_beads");
	else
		if beads_found == 1 then
			BAG_INV:SetInventoryOvertextFlags("beadcollection", kHAlignCenter + kVAlignTop);
		end
		
		local beadText = tostring(beads_found) .. " / "  .. tostring(max_beads);
		BAG_INV:SetInventoryOvertext("beadcollection", beadText);
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_bead_spec(_name, _depth)
	return
	{
		name = _name;
		halo = _name;
		gfx = { image = _name };
		
		command = function(actor)
			actor.value = _name;
			actor:SetDepthValue(_depth);
		end;
		
		on_click = function(flo, bead)
			flo:SetMode(MODE.CUTSCENE);
			game:Set("dress_shop_" .. bead.value, 1);
			local beads_found = game:Get("beads_found_in_dress_shop");
			beads_found = beads_found + 1;
			game:Set("beads_found_in_dress_shop", beads_found);
			
			local position = bead:GetZoneWalkToPoint();
			local key = inv_desc_beadcollection.key;
			
			if beads_found == 1 then
				BAG_INV:AddInventory(inv_desc_beadcollection);
			end
			
			game:SetString("inventory_fly_back_item", key);
			game:Set("inventory_fly_back_loc_X", position.x);
			game:Set("inventory_fly_back_loc_Y", position.y);
			
			-- scroll so the item's SLOT is visible
			BAG_INV:PositionInventoryForVisibility(key);
			
			-- go straight there (don't wait)
			BAG_INV:JumpInventoryToTarget(key);
			
			sfx:PlaySFX("audio/sfx/bead_find.ogg");
			
			-- do the work
			scene:Spawn(inventory_flyback_spec);
			
			bead:Expire();
			scene.FLO:StartProc(wait_for_bead_fly)
			return RESPONSE.IGNORE;
		end;	
	}
end;

function spawnBeads(Table)
	for i = 1, max_beads, 1 do
		if game:Get("dress_shop_" .. Table[i][1]) < 1 then
			scene:Spawn(get_bead_spec(Table[i][1], Table[i][2]));
		end
	end;
end

greenmachine_spec = 
{
	name = "GREENMACHINE";
	halo = "greenmachine";
	gfx = { anim = "anim/m1_dress/ambient1" };
	
	command = function(actor)
		actor:PlayAnim("ambient1");
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_other_machine");
	end;
};

ambient2_spec =
{
	name = "AMBIENT2";
	gfx = { anim = "anim/m1_dress/ambient2" };
	
	command = function(actor)
		actor:PlayAnim("ambient2");
	end;
};

function use_screwdriver_on_beadmachine(flo)
	flo:SetMode(MODE.CUTSCENE);
	--game:Set("beadmachine_open", 1);
	run_super_conversation(flo, "quip_use_screwdriver");
	
	flo:StartProc(goto_bead_machine);
end

function goto_bead_machine(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene:ChainToSubScene("m1_dresspanel");
	wait_subscene();
	
	if game:Get("beadmachine_fixed") > 0 then
		scene.MACHINE:PlayAnim("fixed");
	elseif game:Get("beadmachine_panel_open") == 1 then
		scene.MACHINE:PlayAnim("open");
	else
		scene.MACHINE:PlayAnim("broken");
	end
	
	if game:Get("beadmachine_fixed") > 0 then
		run_super_conversation(flo, "quip_fixed_machine");
		
		if quest_complete("find_beads") then
			add_quest("do_beadwork", false);
		end
		
		if quest_added("find_beadmachine_code") then
			complete_quest("find_beadmachine_code", false);
		end
		
		if quest_added("find_screwdriver") then
			complete_quest("find_screwdriver", false);
		end
		
		complete_quest("fix_beadmachine");
	else
		if game:Get("beadmachine_panel_open") == 1 then
			if not quest_added("find_beadmachine_code") then
				run_super_conversation(flo, "conv_bobbi_need_code");
				add_quest("find_beadmachine_code", false);
			end
		elseif not quest_added("find_screwdriver") or not quest_complete("find_screwdriver") then
			run_super_conversation(flo, "conv_flo_need_screwdriver");
			add_quest("find_screwdriver", false);
		end
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

beadmachine_spec = 
{
	name = "MACHINE";
	halo = "beadmachine";
	gfx = { anim = "anim/m1_dress/beadmachine" };
	
	command = function(actor)
		actor:SetDepthValue(300);
		prepare_actor_text(actor, beadmachine_text_spec);
		actor:ModifySaySpec { mouth_in_actor = { x = 180, y = 400 } };
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		
		if game:Get("beadmachine_fixed") > 0 then
			actor:PlayAnim("fixed");
		elseif game:Get("beadmachine_panel_open") == 1 then
			actor:PlayAnim("open");
		else
			actor:PlayAnim("broken");
		end
	end;
	
	on_arrive = function(flo, beadmachine)
		if game:Get("beadmachine_fixed") < 1 then
			--if game:Get("beadmachine_panel_open") < 1 then
			--	convproc("FLO", "quip_machine_broken");
			--else
				flo:StartProc(goto_bead_machine);
			--end
		elseif game:Get("beadmachine_has_beads") < 1 then
			if BAG_INV:CheckInventory("beads") then
				convproc("FLO", "quip_machine_more_beads");
			elseif game:Get("mg_bead_activity_round") < 1 then
				convproc("FLO", "quip_machine_need_beads");
			end
		else
			goto_scene(flo, "mg_bead");
		end
	end;
	
	on_use_inv = function(item, flo, beadmachine)
		if item == "screwdriver" then
			flo:StartProc(use_screwdriver_on_beadmachine);
			return RESPONSE.INV_HANDLED;
		elseif item == "beads" then
			if game:Get("beadmachine_fixed") < 1 then
				convproc("FLO", "quip_try_to_load_A");
			else
				sfx:PlaySFX("audio/sfx/beads_load.ogg");
				BAG_INV:RemoveInventory("beads");
				game:Set("beadmachine_has_beads", 1);
				game:Set("beadmachine_open", 0);
				goto_scene(flo, "mg_bead");
			end
			return RESPONSE.INV_HANDLED;
		elseif item == "beadcollection" and game:Get("beadmachine_fixed") > 0 then
			convproc("FLO", "quip_try_to_load_B");
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
};
--[[
beadmachine_cover =
{
	name = "BEADMACHINE_COVER";
	--halo =  "beadmachine_panel";
	gfx = { image = "beadmachine_cover" };
	
	command = function(actor)
		actor:SetDepthMode(DEPTH_FRONTMOST);
	end;
	
	on_arrive = function(flo, beadmachine_cover)
		goto_scene(flo, "m1_dresspanel");
		actor:SetAlpha(0);
	end;
}
]]
function get_pole(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("clicked_on_garment_pole") < 1 then
		game:Set("clicked_on_garment_pole", 1);
		run_super_conversation(flo, "quip_pole");
		add_quest("need_pole");
		wait_subscene();
		goto_scene(flo, "mg_clothing");
	elseif game:Get("mg_clothing_activity_round") < 2 then
		run_super_conversation(flo, "quip_pole_not_done");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		run_super_conversation(flo, "quip_pickup_pole");
		game:Set("got_garment_pole", 1);
		scene.POLE:Expire();
		addInventory(inv_desc_garmentpole);
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end;

pole_spec =
{
	name = "POLE";
	halo = "pole";
	gfx = { image = "pole" };
	
	command = function(actor)
		actor:SetDepthValue(2);
	end;
	
	on_arrive = function(flo, pole)
		flo:StartProc(get_pole);
	end;
}

handbags_spec =
{
	name = "HANDBAGS";
	halo = "handbags";
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_handbags");
	end;
}

dress_rack_spec =
{
	name = "DRESS_RACK";
	halo = "dressrack";
	
	command = function(actor)
		actor:SetDepthValue(365);
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_dress_rack");
	end;
}

mirror_spec =
{
	name = "MIRROR";
	halo = "mirror";
	gfx = { image = "mirror" };
	
	command = function(actor)
		actor:SetDepthMode(DEPTH.FRONTMOST);
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_mirror");
	end;
}

fabric_spec =
{
	name = "FABRIC";
	halo = "fabric";
	
	command = function(actor)
		actor:SetDepthValue(205);
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_fabric");
	end;
}

stairs_spec =
{
	name = "STAIRS";
	halo = "stairs";
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_stairs");
	end;
}

wedding_dress_spec = 
{
	name = "WEDDING_DRESS";
	gfx = { image = "Dress_mannequin1" };
	
	command = function(actor)
		actor:SetDepthValue(430);
	end
}

wedding_dress_beads1_spec = 
{
	name = "WEDDING_DRESS_BEADS1";
	gfx = { image = "Dress_mannequin2" };
	
	command = function(actor)
		actor:SetDepthValue(431);
	end
}

wedding_dress_beads2_spec = 
{
	name = "WEDDING_DRESS_BEADS2";
	gfx = { image = "Dress_mannequin3" };
	
	command = function(actor)
		actor:SetDepthValue(432);
	end
}

train_spec = 
{
	name = "TRAIN";
	gfx = { image = "Dress_mannequin4" };
	
	command = function(actor)
		actor:SetDepthValue(435);
	end
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/dressshopmusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.8, 1.0);	--topline, bottomline, topscale, bottomscale
		
		if game:GetLastScene() == "m1_dresspanel" then
			fade_scene_up(false, true);
		else
			fade_scene_up();
		end
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory(inv_desc_screwdriver);
			--BAG_INV:AddInventory(inv_desc_beads);
			--game:Set("got_beads_from_ethel", 1);
			--BAG_INV:AddInventory(inv_desc_curtains);
			--game:Set("got_curtains", 1);
			
			--BAG_INV:SetInventoryOvertext("screwdriver", "DRIVER");
			--BAG_INV:SetInventoryOvertextColor("screwdriver", Color8888(0,255,0,255));
			-- BAG_INV:SetInventoryOvertextFlags("screwdriver", kHAlignRight + kVAlignBottom);
			--BAG_INV:SetInventoryOvertextFlags("screwdriver", kHAlignCenter + kVAlignBottom);
			-- BAG_INV:SetInventoryOvertextFlags("screwdriver", kHAlignLeft + kVAlignTop);
			--game:Set("first_time_dress_shop", 1);
		end
		
		spawn_nav_arrow(to_spendalot_spec);
		
		if game:Get("got_screwdriver") < 1 then
			scene:Spawn(screwdriver_spec);
		end
		
		if game:Get("got_garment_pole") < 1 then
			scene:Spawn(pole_spec);
		end
		
		if game:Get("beads_found_in_dress_shop") < max_beads then
			spawnBeads(beads_Table);
		end
		
		if not quest_complete("wedding_dress") then
			if quest_complete("do_beadwork") then
				scene:Spawn(wedding_dress_beads1_spec);
			end
			
			if quest_complete("finish_beading") then
				scene:Spawn(wedding_dress_beads2_spec);
			end
			
			if quest_complete("need_lace") then
				scene:Spawn(train_spec);
			end
		end
		
		if game:Get("mg_clothing_activity_round") < 2 then
			scene:Spawn(clothesdisplay_spec);
		end
		
		game:SetString("map_position", "m1_dress");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "mannequin", 350 },
		{ "bench", 600 },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{
		scene_setup,
		flo_spec, -- the main actor
		bobbie_spec,
		
		instructions_spec,
		beadmachine_spec,
		greenmachine_spec,
		handbags_spec,
		dress_rack_spec,
		mirror_spec,
		fabric_spec,
		stairs_spec,
		ambient2_spec,
		wedding_dress_spec,
	};
};
